<?php

namespace App\Http\Controllers;

use App\Http\Requests\NoteRequest;
use App\Models\Note;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class BijulandController extends Controller
{
    public function index(): View
    {
        $notes = Note::latest()->paginate(5);
        return view('notes.index', compact('notes'));
    }

    public function create(): View
    {
        return view('notes.create');
    }

    public function store(NoteRequest $request): RedirectResponse
    {
        Note::create($request->validated());
        return redirect()->route('notes.index')->with('success', 'Заметка создана!');
    }

    public function show(Note $note): View
    {
        return view('notes.show', compact('note'));
    }

    public function edit(Note $note): View
    {
        return view('notes.edit', compact('note'));
    }

    public function update(NoteRequest $request, Note $note): RedirectResponse
    {
        $note->update($request->validated());
        return redirect()->route('notes.index')->with('success', 'Заметка обновлена!');
    }

    public function destroy(Note $note): RedirectResponse
    {
        $note->delete();
        return redirect()->route('notes.index')->with('success', 'Заметка удалена!');
    }
}
