<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Note extends Model
{
    use HasFactory;

    protected $connection = 'mysql_bijuland'; // Используемое подключение
    protected $fillable = ['title', 'text_content', 'slug'];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($note) {
            $note->slug = Str::slug($note->title);
        });
    }
}
