<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Регистрация</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">
<div class="bg-white p-8 rounded-lg shadow-md w-96">
    <h2 class="text-2xl font-bold text-center mb-6">Регистрация</h2>

    <form action="{{ route('register') }}" method="POST">
        @csrf
        <div class="mb-4">
            <label class="block text-gray-700">Имя</label>
            <input type="text" name="name" required
                   class="w-full p-2 border border-gray-300 rounded mt-1">
        </div>

        <div class="mb-4">
            <label class="block text-gray-700">Email</label>
            <input type="email" name="email" required
                   class="w-full p-2 border border-gray-300 rounded mt-1">
        </div>

        <div class="mb-4">
            <label class="block text-gray-700">Пароль</label>
            <input type="password" name="password" required
                   class="w-full p-2 border border-gray-300 rounded mt-1">
        </div>

        <div class="mb-4">
            <label class="block text-gray-700">Подтвердите пароль</label>
            <input type="password" name="password_confirmation" required
                   class="w-full p-2 border border-gray-300 rounded mt-1">
        </div>

        <button type="submit"
                class="w-full bg-green-600 text-white p-2 rounded hover:bg-green-700 transition">
            Зарегистрироваться
        </button>
    </form>

    <p class="text-center text-gray-600 mt-4">
        Уже есть аккаунт? <a href="{{ route('login') }}" class="text-blue-600">Войти</a>
    </p>
</div>
</body>
</html>
